/*
===========
ClientConnect

Called when a player begins connecting to the server.
Called again for every map change or tournement restart.

The session information will be valid after exit.

Return NULL if the client should be allowed, otherwise return
a string with the reason for denial.

Otherwise, the client will be sent the current gamestate
and will eventually get to ClientBegin.

firstTime will be qtrue the very first time a client connects
to the server machine, but qfalse on map changes and tournement
restarts.
============
*/
char *ClientConnect( int clientNum, qboolean firstTime, qboolean isBot ) {
	char		*value;
//	char		*areabits;
	gclient_t	*client;
	char		userinfo[MAX_INFO_STRING];
	gentity_t	*ent;
	gentity_t	*te;

	//JediDog: these 2 things are for the anti fake player core
	char gaPortlessIP[24];
	int i;
	int	gaCloseServer = trap_Cvar_VariableIntegerValue("ga_closeServer");

	ent = &g_entities[ clientNum ];

	trap_GetUserinfo( clientNum, userinfo, sizeof( userinfo ) );

	// check to see if they are on the banned IP list
	value = Info_ValueForKey (userinfo, "ip");
	if ( G_FilterPacket( value ) ) {
		return "Banned.";
	}
	
	//JediDog: Added this & Gamall mod, I like this idea too much to deny it :D -- GAMALL'S MOD
	if (gaCloseServer && firstTime) {
		G_LogPrintf("Access denied because the server is closed\n");
		if (gaCloseServer != 2) {
			value = Info_ValueForKey (userinfo, "name");
			gaDisplay(va("^1Closed server: ^5Client ^7<^7%s^7>^5 was denied access.", value));
		}
		return gaClosedServerMsg;
		//G_LogPrintf("blaaa %s", gaClosedServerMsg);
	}//JediDog: End.

	if ( !( ent->r.svFlags & SVF_BOT ) && !isBot && g_needpass.integer ) {
		// check for a password
		value = Info_ValueForKey (userinfo, "password");
		if ( g_password.string[0] && Q_stricmp( g_password.string, "none" ) &&
			strcmp( g_password.string, value) != 0) {
			static char sTemp[1024];
			Q_strncpyz(sTemp, G_GetStripEdString("SVINGAME","INVALID_PASSWORD"), sizeof (sTemp) );
			return sTemp;// return "Invalid password";
		}
	}

	// get the portless ip -- THIS IS GAMALL'S MOD
	strcpy(gaPortlessIP, Info_ValueForKey (userinfo, "ip"));
	for (i = 0 ; i < 24 ; i++)
	{
		if ( gaPortlessIP[i] == ':' )
		{
			gaPortlessIP[i] = 0;
			break;
		}
	}
	//JediDog: begin PB detection
	//and this is where the part that i did goes against q3fill/fake player attack
	//end of PB detection

	// they can connect
	ent->client = level.clients + clientNum;
	client = ent->client;

